const staticCacheName = 'site-static';
const assets = [
  '/',
  '/manifest.json',
  '/index.html',
  '/js/app.js',
  '/handler.js',
  '/board.js',
  '/rules.js',
  '/candy.js',
  '/mainLayout.css',
  '/graphics/blue-candy.png',
  '/graphics/blue-special.png',
  '/graphics/color-bomb.png',
  '/graphics/green-candy.png',
  '/graphics/green-special.png',
  '/graphics/Oblue-candy.png',
  '/graphics/Ogreen-candy.png',
  '/graphics/Oorange-candy.png',
  '/graphics/Opurple-candy.png',
  '/graphics/orange-candy.png',
  '/graphics/orange-special.png',
  '/graphics/Ored-candy.png',
  '/graphics/Oyellow-candy.png',
  '/graphics/purple-candy.png',
  '/graphics/purple-special.png',
  '/graphics/red-candy.png',
  '/graphics/red-special.png',
  '/graphics/yellow-candy.png',
  '/img/r1.png',
  '/img/r2.png',
  '/img/r3.gif',
  '/img/z1.png',
  '/img/z2.png',
  '/img/z3.gif',
  '/img/btn_newgame.png',
  '/img/btn_sound_off.png',
  '/img/btn_sound_on.jpg',
  // Music
  '/music/1.mp3',
  '/music/1.wav',
  '/music/2.mp3',
  '/music/2.wav',
  '/music/3.mp3',
  '/music/4.wav',
  '/music/5.mp3',
  '/music/5.wav',
  '/music/6.mp3',
  '/music/6.wav',
  '/music/7.mp3',
  '/music/7.wav',
  '/music/8.mp3',
  '/music/8.wav',
  '/music/9.mp3',
  '/music/9.wav',
  '/music/10.mp3',
  '/music/10.wav',
  '/music/main.mp3',
  '/candy-crush-background-2.png',
  '/data/start.json',
  'https://ajax.googleapis.com/ajax/libs/jquery/3.1.1/jquery.min.js',
  'https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0-alpha.6/css/bootstrap.css',
  'https://cdnjs.cloudflare.com/ajax/libs/seedrandom/2.4.2/seedrandom.js'
];

self.addEventListener('install', evt => {
  evt.waitUntil(
    caches.open(staticCacheName).then((cache) => {
      cache.addAll(assets).catch(e => console.log(e))
    })
  );
});

self.addEventListener('activate', evt => {
  evt.waitUntil(
    caches.keys().then(keys => {
      return Promise.all(keys
        .filter(key => key !== staticCacheName)
        .map(key => caches.delete(key))
      );
    })
  );
});

self.addEventListener('fetch', evt => {
  evt.respondWith(
    caches.match(evt.request).then(cacheRes => {
      return cacheRes || fetch(evt.request)
    })
  );
}); 